# 🔐 How to Set Up Shopify Credentials

## ✅ Good News: You DON'T Add Credentials to .env!

The Shopify integration is designed to be **more secure** by storing credentials in the **database**, not in `.env` files.

---

## 📝 How to Connect Shopify (Step-by-Step)

### Step 1: Get Your Shopify Credentials

1. **Go to your Shopify Admin Panel**
   - Log in to your Shopify store
   - URL: `https://yourstore.myshopify.com/admin`

2. **Navigate to Apps Settings**
   - Click **Settings** (bottom left)
   - Click **Apps and sales channels**

3. **Create a Custom App**
   - Click **"Develop apps"** (top right)
   - Click **"Create an app"**
   - Name it: `Marketing Bot Integration`
   - Click **"Create app"**

4. **Configure API Scopes**
   - Click **"Configure Admin API scopes"**
   - Enable these permissions:
     - ✅ `read_products`
     - ✅ `read_orders`
     - ✅ `read_customers`
     - ✅ `read_inventory`
   - Click **"Save"**

5. **Install the App**
   - Click **"Install app"** button
   - Click **"Install"** to confirm

6. **Get Your Access Token**
   - Click **"Reveal token once"**
   - **COPY THIS TOKEN** - You'll need it!
   - It looks like: `shpat_abc123...`

---

### Step 2: Connect in Your Dashboard

1. **Run Your Laravel Application**
   ```bash
   cd "/Users/hicham/Downloads/Gemine Test"
   php artisan serve
   ```

2. **Open Your Browser**
   - Go to: `http://localhost:8000`
   - Log in to your account

3. **Navigate to Marketing Dashboard**
   - Click **Marketing Bot** in the menu
   - You'll see the dashboard

4. **Go to Shopify Settings**
   - Click **"Customize Dashboard"** button (top right)
   - Or go directly to: `http://localhost:8000/dashboard/user/marketing-bot/shopify/settings`

5. **Enter Your Credentials**
   - **Shop Domain**: `yourstore.myshopify.com`
   - **Access Token**: Paste the token you copied (starts with `shpat_`)
   - Click **"Connect Store"**

6. **Wait for Sync**
   - The system will:
     - ✅ Test the connection
     - ✅ Sync all your products
     - ✅ Sync recent orders
     - ✅ Show success message

---

## 🎯 Where Credentials Are Stored

### Database (Secure) ✅
- Shop domain
- Access token (encrypted)
- API settings
- Sync status

### .env File (Not Used) ❌
- No Shopify credentials here!
- Only optional config like API version

---

## 🔒 Why This Is More Secure

1. **Per-User Credentials**: Each user can connect their own Shopify store
2. **Database Encryption**: Tokens are encrypted in the database
3. **No Git Exposure**: `.env` files can accidentally be committed to Git
4. **Easy Management**: Users can connect/disconnect through UI

---

## 📊 What Happens After Connecting

Once connected, you'll see:
- ✅ Shopify banner on dashboard
- ✅ Today's revenue metrics
- ✅ Order statistics
- ✅ Top selling products
- ✅ Revenue trend chart
- ✅ Manual sync button

---

## 🔄 Manual Sync

To sync data manually:
1. Go to dashboard
2. Click **"Sync Now"** button in the Shopify banner
3. Wait for sync to complete
4. See updated metrics!

---

## ❓ Troubleshooting

### "Failed to connect to Shopify"
- ✅ Check shop domain format: `yourstore.myshopify.com`
- ✅ Verify access token is correct
- ✅ Ensure API scopes are configured
- ✅ Make sure app is installed on your store

### "No data showing"
- ✅ Click "Sync Now" to trigger manual sync
- ✅ Check you have products in Shopify
- ✅ Check you have orders in Shopify
- ✅ Wait a few minutes for sync to complete

### "Access token invalid"
- ✅ Go back to Shopify admin
- ✅ Apps → Your app → API credentials
- ✅ Generate a new access token
- ✅ Reconnect in dashboard

---

## 🎉 You're All Set!

Once connected:
- Automatic syncing every 15 minutes (configurable)
- Real-time analytics on dashboard
- Campaign ROI tracking
- Product performance insights

**No .env configuration needed!** Everything is managed through the UI! 🚀
